<?php
if (!class_exists('Newses_Full_width_column_Slider')) :
    /**
     * Adds Newses_Full_width_column_Slider widget.
     */
    class Newses_Full_width_column_Slider extends Newses_Widget_Base
    {
        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $this->text_fields = array('newses-posts-full-width-slider-title', 'newses-excerpt-length', 'newses-posts-full-width-slider-number');
            $this->select_fields = array('newses-select-category', 'newses-show-excerpt');

            $widget_ops = array(
                'classname' => 'newses_full_width_column_slider_widget',
                'description' => __('Displays 4 column posts slider from selected category.', 'newses'),
                'customize_selective_refresh' => true,
            );

            parent::__construct('newses_full_width_column_slider', __('AR: 4 Column Full Slider', 'newses'), $widget_ops);
        }

        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args Widget arguments.
         * @param array $instance Saved values from database.
         */

        public function widget($args, $instance)
        {
            $instance = parent::newses_sanitize_data($instance, $instance);


            /** This filter is documented in wp-includes/default-widgets.php */
            $title = apply_filters('widget_title', $instance['newses-posts-full-width-slider-title'], $instance, $this->id_base);
            $category = isset($instance['newses-select-category']) ? $instance['newses-select-category'] : 0;
            $number_of_posts = 25;

            // open the widget container
            echo $args['before_widget'];
            ?>
            <div class="mg-posts-sec mg-posts-modul-1 wd-back">
            <?php $site_title_design = get_theme_mod('site_title_design','st3');
            if($title !='') { ?>
            <div class="mg-sec-title <?php echo $site_title_design; ?>"> 
                <h4><span class="bg"><?php echo $title; ?></span></h4>
            </div> <!-- // mg-sec-title -->
           <?php }  $all_posts = newses_get_posts($number_of_posts, $category); ?>
            <div class="no-gutter no_gutter swiper-container">
                <div class="swiper-wrapper">
                    <!-- item -->
                <?php
                    if ($all_posts->have_posts()) :
                        while ($all_posts->have_posts()) : $all_posts->the_post();
                            global $post;
                            $url = newses_get_freatured_image_url($post->ID, 'newses-slider-full');
                            ?>
                        <div class="swiper-slide">
                            <div class="mg-blog-post-3 back-img"style="background-image: url('<?php echo esc_url($url); ?>');">
                                <a class="link-div" href="<?php the_permalink(); ?>"></a>
                                <div class="mg-blog-inner">
                                    <div class="mg-blog-category">
                                        <?php newses_post_categories(); ?>
                                    </div>
                                    <h4 class="title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <?php
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                    </div>
                </div>
            </div>

            <?php
            // close the widget container
            echo $args['after_widget'];
        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         * @param array $instance Previously saved values from database.
         */
        public function form($instance)
        {
            $this->form_instance = $instance;
            $options = array(
                'true' => __('Yes', 'newses'),
                'false' => __('No', 'newses')

            );
            $categories = newses_get_terms();
            if (isset($categories) && !empty($categories)) {
                echo parent::newses_generate_text_input('newses-posts-full-width-slider-title', __('Title', 'newses'), 'Posts 4 Column Full-width Slider');

                echo parent::newses_generate_select_options('newses-select-category', __('Select category', 'newses'), $categories);


            }
        }
    }
endif;