<?php 
// Adding customizer home page setting
function newses_style_customizer( $wp_customize ){
//Theme color
class WP_color_Customize_Control extends WP_Customize_Control {
public $type = 'new_menu';

       function render_content()
	   {
	   echo _e('<h3>Select Your Theme Color</h3>','newses');
		  $name = '_customize-color-radio-' . $this->id; 
		  foreach($this->choices as $key => $value ) {
            ?>
               <label>
				<input type="radio" value="<?php echo $key; ?>" name="<?php echo esc_attr( $name ); ?>" data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>" <?php if($this->value() == $key){ echo 'checked'; } ?>>
				<img <?php if($this->value() == $key){ echo 'class="selected_img"'; } ?> src="<?php echo get_template_directory_uri(); ?>/images/color/<?php echo $value; ?>" alt="<?php echo esc_attr( $value ); ?>" />
				</label>
				
            <?php
		  } ?>
		
		  <script>
			jQuery(document).ready(function($) {
				$("#customize-control-newses_theme_color label img").click(function(){
					$("#customize-control-newses_theme_color label img").removeClass("selected_img");
					$(this).addClass("selected_img");
				});
			});
		  </script>

		  <script>
			jQuery(document).ready(function($) {
				$("#customize-control-newses_theme_style label img").click(function(){
					$("#customize-control-newses_theme_style label img").removeClass("selected_img");
					$(this).addClass("selected_img");
				});
			});
		  </script>

		  <script>
			jQuery(document).ready(function($) {
				$("#customize-control-newses_default_bg_image label img").click(function(){
					$("#customize-control-newses_default_bg_image label img").removeClass("selected_img");
					$(this).addClass("selected_img");
				});
			});
		  </script>
		  <?php 
       }

}

class Newses_WP_color_Customize_Control extends WP_Customize_Control {
public $type = 'new_menu';

       function render_content()
	   {
	   echo _e('<h3>Select Your Theme Style</h3>','newses');
		  $name = '_customize-color-radio-' . $this->id; 
		  foreach($this->choices as $key => $value ) {
            ?>
               <label>
				<input type="radio" value="<?php echo $key; ?>" name="<?php echo esc_attr( $name ); ?>" data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>" <?php if($this->value() == $key){ echo 'checked'; } ?>>
				<img <?php if($this->value() == $key){ echo 'class="selected_img"'; } ?> src="<?php echo get_template_directory_uri(); ?>/images/color/<?php echo $value; ?>" alt="<?php echo esc_attr( $value ); ?>" />
				</label>
				
            <?php
		  } ?>
		
		  <script>
			jQuery(document).ready(function($) {
				$("#customize-control-newses_theme_color label img").click(function(){
					$("#customize-control-newses_theme_color label img").removeClass("selected_img");
					$(this).addClass("selected_img");
				});
			});
		  </script>
		  <?php 
       }

}

//Predefined Background color
class WP_back_Customize_Control extends WP_Customize_Control {
public $type = 'new_menu';

       function render_content()
       
	   {
	   echo '<h3>Predefined Default Background</h3>';
		  $name = '_customize-radio-' . $this->id; 
		  foreach($this->choices as $key => $value ) {
            ?>
               <label>
				<input type="radio" value="<?php echo $key; ?>" name="<?php echo esc_attr( $name ); ?>" data-customize-setting-link="<?php echo esc_attr( $this->id ); ?>" <?php if($this->value() == $key){ echo 'checked'; } ?>>
				
				<img <?php if($this->value() == $key){ echo 'class="background_active"'; } ?> src="<?php echo get_template_directory_uri(); ?>/images/bg-pattern/<?php echo esc_attr( $key ); ?>" alt="<?php echo esc_attr( $value ); ?>" />
				</label>
            <?php
		  }
		  ?>
		  <script>
			jQuery(document).ready(function($) {
				$("#customize_control_newses_options-back_image label img").click(function(){
					$("#customize_control_newses_options-back_image label img").removeClass("background_active");
					$(this).addClass("background_active");
				});
			});
		  </script>
		  <?php
       }

}

//Line Break 
class WP_line_break_Customize_Control extends WP_Customize_Control {
public $type = 'new_menu';

       function render_content()
	   {
	   echo '<hr></hr>';
		} }
		
//Line Break 
class WP_line_break_header_Customize_Control extends WP_Customize_Control {
public $type = 'new_menu';

       function render_content()
	   {
	   echo '<hr></hr>';
		} }	


	//Theme Layout Panel
	 $wp_customize->add_panel('newses_theme_style_setting', array(
	 	'priority' => 32,
     	'capability' =>  'edit_theme_options',
     	'theme_supports' =>      '',
     	'title' =>  __( 'Theme Style Palette', 'newses'),
    ) );

	//Theme Layout
	$wp_customize->add_section( 'newses_theme_layout_setting' , array(
		'title' => __('Theme Layout setting', 'newses'),
		'panel' => 'newses_theme_style_setting',
   	) );
	
	$wp_customize->add_setting( 'newses_theme_layout_options', array(
       'default' => 'wide',
       'sanitize_callback' => 'sanitize_text_field',
   ) );

    $wp_customize->add_control( 'newses_theme_layout_options', array(
        'type' => 'select',
        'label' => __('Select Theme layout Type','newses'),
        'section' => 'newses_theme_layout_setting',
        'choices' => array('wide'=>__('Wide', 'newses'), 'boxed'=>__('Boxed', 'newses')),
    ) );

    /* Theme Style settings */
	$wp_customize->add_section( 'newses_theme_style_settings' , array(
		'title' => __('Theme Style', 'newses'),
		'panel' => 'newses_theme_style_setting',
   	) );
	
	 //Theme Style Scheme
	$wp_customize->add_setting(
		'newses_theme_style', array(
		'default' => 'light.css',  
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
    ) );
	$wp_customize->add_control(new Newses_WP_color_Customize_Control($wp_customize,'newses_theme_style', array(
        'label'   => __('Select Your Theme Style', 'newses'),
        'section' => 'newses_theme_style_settings',
		'type' => 'radio',
		'settings' => 'newses_theme_style',	
		'choices' => array(
			'light.css' => 'white.png',
			'black.css' => 'black.png',
			))
	) );

	
	/* Theme Style settings */
	$wp_customize->add_section( 'newses_theme_style' , array(
		'title' => __('Predefined Colors', 'newses'),
		'panel' => 'newses_theme_style_setting',
   	) );
	
	 //Theme Color Scheme
	$wp_customize->add_setting(
		'newses_theme_color', array(
		'default' => 'default.css',  
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
    ) );
	$wp_customize->add_control(new WP_color_Customize_Control($wp_customize,'newses_theme_color', array(
        'label'   => __('Select Your Theme Color', 'newses'),
        'section' => 'newses_theme_style',
		'type' => 'radio',
		'settings' => 'newses_theme_color',	
		'choices' => array(
			'default.css' => 'default.png',
			'red.css' => 'red.png',
			'blue.css' => 'blue.png',
			'cyan.css' => 'cyan.png',
			'pink.css' => 'pink.png',
			'wordpress.css' => 'wordpress.png',
			'blue-dark.css' => 'blue-dark.png',
			'orange.css' => 'orange.png',
			'porsche.css' => 'porsche.png'
			))
	) );
	
	/* Theme Style settings */
	$wp_customize->add_section( 'newses_theme_default_bg', array(
		'title' => __('Predefined Background', 'newses'),
		'panel' => 'newses_theme_style_setting',
   	) );

	$wp_customize->add_setting('newses_default_bg_image', array(
		'default' => 'bg-img1.png',  
		'sanitize_callback' => 'sanitize_text_field',
    ) );
	$wp_customize->add_control(new WP_back_Customize_Control($wp_customize,'newses_default_bg_image', array(
        'label'   => __('Default Background Image', 'newses'),
        'section' => 'newses_theme_default_bg',
		'type' => 'radio',
		'choices' => array(
			'bgone.png' => 'Pattern 0',
            'bgtwo.png' => 'Pattern 1',
            'bgthree.png' => 'Pattern 2',
            'bgfour.png' => 'Pattern 3',
			'bgfive.png' => 'Pattern 4',
			'bgsix.jpg' => 'Pattern 5',
			'bgseven.jpg' => 'Pattern 6',
			'bgeight.jpg' => 'Pattern 7',
			'bgnine.jpg' => 'Pattern 8',
			'bgten.jpg' => 'Pattern 9',))
	) );
	
	//Own Skin Color
	$wp_customize->add_section( 'newses_theme_own_color' , array(
		'title' => __('Set Your Own Theme Color', 'newses'),
		'panel' => 'newses_theme_style_setting',
   	) );
	
	//Own Color Enable
	$wp_customize->add_setting( 'newses_own_color_enable',
		   array(
			  'default' => false,
			  'sanitize_callback' => 'newses_sanitize_checkbox'
		   )
		);
		 
		$wp_customize->add_control( new Newses_Toggle_Control( $wp_customize, 'newses_own_color_enable',
		   array(
			  'label' => esc_html__( 'Own Theme Color','newses' ),
			  'section' => 'newses_theme_own_color'
		   )
	) );
	
	
	//Theme Color
	$wp_customize->add_setting('own_skin_color', array(
		'default' => '#f44336',
    ) );
	
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'own_skin_color', array(
		'label' => __('Select Your Theme Color ', 'newses' ),
		'section' => 'newses_theme_own_color',
		'settings' => 'own_skin_color',) 
	) );
}
add_action( 'customize_register', 'newses_style_customizer' );