<?php
/**
 * Recommended Plugins Panel
 *
 * @package Newses
 */
?>
<div id="recommended-plugins-panel" class="panel-left">
	<?php 
	$newses_free_plugins = array(
		'one-click-demo-import' => array(
		    'name'     	=> 'One Click Demo Import',
			'slug'     	=> 'one-click-demo-import',
			'filename' 	=> 'one-click-demo-import.php',
		),
	);
	if( !empty( $newses_free_plugins ) ) { ?>
		<div class="recomended-plugin-wrap">
		<?php
		foreach( $newses_free_plugins as $newses_plugin ) {
			$info 		= newses_call_plugin_api( $newses_plugin['slug'] ); ?>
			<div class="recom-plugin-wrap mb-0">
				<div class="plugin-title-install clearfix">
					<span class="title" title="<?php echo esc_attr( $plugin['name'] ); ?>">
					<?php echo esc_html( $newses_plugin['name'] ); ?>
					</span>
					<?php if($newses_plugin['slug'] == 'one-click-demo-import') : ?>
					<p><?php echo esc_html( 'First of all download demo files from', 'newses' ); ?></h3>
					<a target="_blank" href="<?php echo esc_url( 'https://themeansar.com/free-themes/newses/' ); ?>"><?php esc_html_e( 'Newses Detail page', 'newses' ); ?></a>
					<?php echo esc_html(', then install and activate','newses'); ?>
					<a href="https://wordpress.org/plugins/one-click-demo-import/" target="_blank"><?php echo esc_html( 'One Click Demo Import', 'newses' ); ?></a><?php echo esc_html(' plugin. After that, import sample demo content, visit Import Demo Data menu under Appearance.', 'newses'); ?></p>
					<?php endif; ?>
					<?php echo '<div class="button-wrap">';
					echo Newses_Getting_Started_Page_Plugin_Helper::instance()->get_button_html( $newses_plugin['slug'] );
					echo '</div>';
					?>
				</div>
			</div>
			</br>
			<?php
		} ?>
		</div>
	<?php
	} ?>
</div>