<?php define( 'NEWSES_THEME_DIR', get_template_directory() . '/' );
	define( 'NEWSES_THEME_URI', get_template_directory_uri() . '/' );
	define( 'NEWSES_THEME_SETTINGS', 'newses-settings' );
	
	
	$newses_theme_path = get_template_directory() . '/inc/ansar/';

	require( $newses_theme_path . '/newses-custom-navwalker.php' );
	require( $newses_theme_path . '/default_menu_walker.php' );
	require( $newses_theme_path . '/font/font.php');
	require( $newses_theme_path . '/template-tags.php');
	require( $newses_theme_path . '/template-functions.php');
	require( $newses_theme_path. '/widgets/widgets-common-functions.php');
	require ( $newses_theme_path . '/custom-control/custom-control.php');
	require ( $newses_theme_path . '/newses-pagination.php');

	require( $newses_theme_path .'/hooks/header-footer-hooks/functions.php');
	require( $newses_theme_path .'/hooks/header-footer-hooks/newses-hooks-settings.php');
	require( $newses_theme_path .'/hooks/hooks-header-footer-front.php');


	$newses_theme_start = wp_get_theme();
	if ( 'Newses' == $newses_theme_start->name) {
	if ( is_admin() ) {
		require ($newses_theme_path . '/admin/getting-started.php');
	}
	}

	// Theme version.
	$newses_theme = wp_get_theme();
	define( 'NEWSES_THEME_VERSION', $newses_theme->get( 'Version' ) );
	define ( 'NEWSES_THEME_NAME', $newses_theme->get( 'Name' ) );

	/*-----------------------------------------------------------------------------------*/
	/*	Enqueue scripts and styles.
	/*-----------------------------------------------------------------------------------*/
	require( $newses_theme_path .'/enqueue.php');
	/* ----------------------------------------------------------------------------------- */
	/* Customizer */
	/* ----------------------------------------------------------------------------------- */
	require( $newses_theme_path . '/customize/customizer.php');

	//Customize Footer
	require get_template_directory().'/inc/ansar/customize/customize-footer.php';

	 //Style and color
	require get_template_directory().'/inc/ansar/customize/customize-theme-style.php';

	//Typography
	require get_template_directory().'/inc/ansar/customize/customizer-typography.php';

	/* custom-color file. */
	require( get_template_directory() . '/css/colors/custom-color.php');

	/* color css file. */
	require( get_template_directory() . '/css/colors/color-css.php');

	/* TGMPA */
	require_once  get_template_directory()  . '/inc/ansar/tgm/class-tgm-plugin-activation.php';

	/* ----------------------------------------------------------------------------------- */
	/* Customizer */
	/* ----------------------------------------------------------------------------------- */

	require( $newses_theme_path  . '/widgets/widgets-init.php');

	/* ----------------------------------------------------------------------------------- */
	/* Widget */
	/* ----------------------------------------------------------------------------------- */

	require( $newses_theme_path  . '/hooks/hooks-init.php');
	

if ( ! function_exists( 'newses_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function newses_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on newses, use a find and replace
	 * to change 'newses' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'newses', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/* Add theme support for gutenberg block */
	add_theme_support( 'align-wide' );

	// Add theme support for Responsive Videos.
	add_theme_support( 'jetpack-responsive-videos' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// Add featured image sizes
        add_image_size('newses-slider-full', 1280, 720, true); // width, height, crop
        add_image_size('newses-featured', 1024, 0, false ); // width, height, crop
        add_image_size('newses-medium', 720, 380, true); // width, height, crop

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary menu', 'newses' ),
        'footer' => __( 'Footer menu', 'newses' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'newses_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

    // Set up the woocommerce feature.
    add_theme_support( 'woocommerce');

     // Woocommerce Gallery Support
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );

    // Added theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	//Custom logo
	
	//Custom logo
	add_theme_support( 'custom-logo');
	
	// custom header Support
			$args = array(
			'default-image'		=>  get_template_directory_uri() .'/images/head-back.jpg',
			'width'			=> '1600',
			'height'		=> '600',
			'flex-height'		=> false,
			'flex-width'		=> false,
			'header-text'		=> true,
			'default-text-color'	=> 'fff',
            'wp-head-callback' => 'newses_site_info_style',

		);
		add_theme_support( 'custom-header', $args );
	

}
endif;
add_action( 'after_setup_theme', 'newses_setup' );


	function newses_the_custom_logo() {
	
		if ( function_exists( 'the_custom_logo' ) ) {
			the_custom_logo();
		}

	}

	add_filter('get_custom_logo','newses_logo_class');


	function newses_logo_class($html)
	{
	$html = str_replace('custom-logo-link', 'navbar-brand', $html);
	return $html;
	}

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function newses_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'newses_content_width', 640 );
}
add_action( 'after_setup_theme', 'newses_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function newses_widgets_init() {
	
	$newses_footer_column_layout = esc_attr(get_theme_mod('newses_footer_column_layout',3));
	
	$newses_footer_column_layout = 12 / $newses_footer_column_layout;
	$site_title_design = get_theme_mod('site_title_design','st3');
	
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Widget Area', 'newses' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="mg-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-sec-title '.$site_title_design.'"><h6><span class="bg">',
		'after_title'   => '</span></h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Top Front Slider Right Side Widget Area', 'newses'),
		'id'            => 'slider-right-sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="col-md-3 slider-right-sidebar-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-sec-title '.$site_title_design.'"><h6><span class="bg">',
		'after_title'   => '</span></h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Top Front Slider Left Side Widget Area', 'newses'),
		'id'            => 'slider-left-sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="col-md-3 slider-left-sidebar-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-sec-title '.$site_title_design.'"><h6><span class="bg">',
		'after_title'   => '</span></h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Off Canvas Content Section', 'newses'),
		'id'            => 'off-canvas-content',
		'description'   => '',
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => '',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Front-page Content Section', 'newses'),
		'id'            => 'front-page-content',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="newses-front-page-content-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-sec-title '.$site_title_design.'"><h6><span class="bg">',
		'after_title'   => '</span></h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Front-Page Left Sidebar Section', 'newses'),
		'id'            => 'front-left-page-sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="mg-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-sec-title '.$site_title_design.'"><h6><span class="bg">',
		'after_title'   => '</span></h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Front-Page Right Sidebar Section', 'newses'),
		'id'            => 'front-right-page-sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="mg-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-sec-title '.$site_title_design.'"><h6><span class="bg">',
		'after_title'   => '</span></h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Before Footer Widget Area', 'newses' ),
		'id'            => 'before_footer_widget_area',
		'description'   => '',
		'before_widget' => '',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="mg-sec-title '.$site_title_design.'"><h6><span class="bg">',
		'after_title'   => '</span></h6></div>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Instagram Widget Area', 'newses' ),
		'id'            => 'instagram_widget_area',
		'description'   => '',
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => '',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget Area', 'newses' ),
		'id'            => 'footer_widget_area',
		'description'   => '',
		'before_widget' => '<div class="col-md-'.$newses_footer_column_layout.' col-sm-6"><div id="%1$s" class="mg-widget %2$s">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<div class="mg-sec-title '.$site_title_design.'"><h6><span class="bg">',
		'after_title'   => '</span></h6></div>',
	) );

}
add_action( 'widgets_init', 'newses_widgets_init' );

//Editor Styling 
add_editor_style( array( 'css/editor-style.css') );


add_filter('wp_nav_menu_items', 'newses_add_home_link', 1, 2);
function newses_add_home_link($items, $args){
    if( $args->theme_location == 'primary' ){
        $item = '<li class="active home"><a class="nav-link homebtn" title="Home" href="'. esc_url( home_url() ) .'">' . "<span class='fa fa-home'></span>" . '</a></li>';
        $items = $item . $items;
    }
    return $items;
}

if ( ! function_exists( 'wp_body_open' ) ) {

	/**
	 * Shim for wp_body_open, ensuring backward compatibility with versions of WordPress older than 5.2.
	 */
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}


/* Category Js */
if(!function_exists('newses_category_js')):
    function newses_category_js(){
        if( null !== ( $screen = get_current_screen() ) && 'edit-category' !== $screen->id ) {
            return;
        }
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( 'wp-color-picker' );
    }
endif;
add_action( 'admin_enqueue_scripts', 'newses_category_js' );

if(!function_exists('newses_colorpicker_init_inline')):
    function newses_colorpicker_init_inline() {
        if( null !== ( $screen = get_current_screen() ) && 'edit-category' !== $screen->id ) {
            return;
        }
        ?>
        <script>
            jQuery( document ).ready( function( $ ) {
                jQuery( '.colorpicker' ).wpColorPicker();
            } );

        </script>
        <?php
    }
endif;
add_action( 'admin_print_scripts', 'newses_colorpicker_init_inline', 20 );

/*Category add form fields*/
if(!function_exists('newses_colorpicker_init_inline')):
    function newses_add_category_fields() {
        ?>
        <div class="form-field term-color-wrap">
            <label for="term-colorpicker"><?php _e( 'Category Color', 'newses' ); ?></label>
            <input name="category_color" class="colorpicker" id="term-colorpicker" />
            <p><?php _e('Select color for this category that will be displayed on the front end on many sections.','newses');?></p>
        </div>
        <?php
    }
endif;
add_action( 'category_add_form_fields', 'newses_add_category_fields'  );

/*Category edit form fields*/
if(!function_exists('newses_edit_category_fields')):
    function newses_edit_category_fields($term) {
        $color = get_term_meta( $term->term_id, 'category_color', true );
        ?>
        <tr class="form-field term-color-wrap">
            <th scope="row"><label for="term-colorpicker"><?php _e( 'Category Color', 'newses' ); ?></label></th>
            <td>
                <input name="category_color" value="<?php echo esc_attr($color); ?>" class="colorpicker" id="term-colorpicker" />
                <p class="description"><?php _e('Select color for this category that will be displayed on the front end on many sections.','newses');?></p>
            </td>
        </tr>
        <?php
    }
endif;
add_action( 'category_edit_form_fields', 'newses_edit_category_fields' , 10 );