<?php
/**
 * The template for displaying all single posts and attachments
 */
?>
<?php get_header(); ?>
<div class="container">
  <div class="row">
    <div class="col-sm-8 col-md-9">
      <main class="main-column">
        <?php
        if ( have_posts() ) : while ( have_posts() ) :
        the_post(); ?>

        <h1><?php the_title() ?></h1>

        <div class="content-padding">
          <?php
          // The following determines what the post format is and shows the correct file accordingly
          $format = get_post_format();
          get_template_part( 'includes/post-formats/' . $format );
          if ( $format == '' ) {
            get_template_part( 'includes/post-formats/standard' );
          } ?>

          <?php get_template_part( 'includes/post-formats/related-posts' ); ?>

          <?php comments_template( '', TRUE ); ?>

          <?php endwhile;
          endif; ?>
        </div>
      </main>
    </div>
    <div class="sidebar sidebar-secondary col-sm-4 col-md-3">
      <?php dynamic_sidebar( 'sidebar-secondary' ); ?>
    </div>

  </div>
</div>

<?php get_footer(); ?>
