<?php
/**
 * Template Name: Gallery
 */

get_header(); ?>

  <div class="container">

    <main class="main-column">
      <?php
      // Get page content
      if ( have_posts() ) {
        while ( have_posts() ) {
          the_post();
        }
        the_content();
      }
      ?>

      <div class="content-padding">
        <div class="gallery">
          <?php
          global $more;
          $more       = 0;
          $values     = get_post_custom_values( "category-include" );
          $cat        = $values[0];
          $catinclude = 'gallery_category=' . $cat;

          $temp     = $wp_query;
          $wp_query = NULL;
          $wp_query = new WP_Query();
          $wp_query->query( "post_type=gallery&" . $catinclude . "&paged=" . $paged . '&showposts=5' );

          if ( ! have_posts() ) { ?>
            <div id="post-0" class="post error404 not-found">
              <h3 class="entry-title"><?php _e( 'Not Found' ); ?></h3>

              <div class="entry-content">
                <p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.' ); ?></p>
              </div>
              <!-- .entry-content -->
            </div><!-- #post-0 -->
          <?php } ?>

          <!-- BEGIN Gallery -->
          <?php
          // Do not show filtering block if we are on the specific portfolio category page.
          if ( empty( $cat ) ) { ?>
            <div id="filter-by" class="btn-group">

              <?php
              $status_terms = get_terms( 'gallery_category' );
              if ( ! empty( $status_terms ) && is_array( $status_terms ) ) { ?>
                <a href="#" data-filter="isotope-item" class="btn active"><?php _e( 'All' ); ?></a>
                <?php
                foreach ( $status_terms as $status_term ) {
                  echo '<a class="btn" href="' . get_term_link( $status_term->slug, $status_term->taxonomy ) . '" data-filter="' . $status_term->slug . '" title="' . sprintf( __( 'View all %s' ), $status_term->name ) . '">' . $status_term->name . '</a>';
                }
              }
              ?>
            </div>
          <?php } ?>

          <div class="items">

            <div class="isotope">
              <?php
              $i = 1;
              if ( have_posts() ) {
                while ( have_posts() ) : the_post();

				  $images = get_field('gallery_item');
				  $size = 'full'; // (thumbnail, medium, large, full or custom size)
				  
                  $post_meta_data = get_post_custom( $post->ID );
                  foreach ( $images as $image ) {
                    $term_list = '';
                    $terms     = get_the_terms( $post->ID, 'gallery_category' );

                    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                      foreach ( $terms as $term ) {
                        $term_list .= $term->slug;
                      }
                    }
                    
                    ?>
				
                    <div class="item isotope-item <?php echo $term_list; ?>">

                      <a href="<?php echo $image['url']; ?>" rel="gallery_<?php echo $term_list; ?>">
                        <img src='<?php echo $image['sizes']['medium']; ?>' width='415' height='300'
                             alt='<?php echo $image['alt']; ?>'/>
                        <span class="zoom-icon"><i class="fa fa-search"></i></span>
                      </a>

                    </div>

                  <?php }  ?>



                  <?php $i ++;
                endwhile;
              } ?>
            </div>

          </div>

          <?php
          wp_reset_query();
          ?>
        </div>
      </div>

    </main>

  </div>

<?php get_footer(); ?>