<?php

if ( ! function_exists( 'theme_setup' ) ) :
  /**
   * Sets up theme defaults and registers support for various WordPress features.
   *
   * Note that this function is hooked into the after_setup_theme hook, which
   * runs before the init hook. The init hook is too late for some features, such
   * as indicating support for post thumbnails.
   *
   */
  function theme_setup() {

    /*
     * Make theme available for translation.
     * Translations can be filed in the /languages/ directory.
     * If you're building a theme based on twentyfifteen, use a find and replace
     * to change 'twentyfifteen' to the name of your theme in all the template files
     */
    load_theme_textdomain( 'radio', get_template_directory() . '/languages' );

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    /*
     * Let WordPress manage the document title.
     * By adding theme support, we declare that this theme does not use a
     * hard-coded <title> tag in the document head, and expect WordPress to
     * provide it for us.
     */
    add_theme_support( 'title-tag' );

    /*
     * Enable support for Post Thumbnails on posts and pages.
     *
     * See: https://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
     */
    add_theme_support( 'post-thumbnails' );
    set_post_thumbnail_size( 825, 510, TRUE );

    // This theme uses wp_nav_menu() in two locations.
    register_nav_menus( array(
      'primary' => __( 'Primary Menu' ),
      'social'  => __( 'Secondary Menu' ),
    ) );

    /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.
     */
    add_theme_support( 'html5', array(
      'search-form',
      'comment-form',
      'comment-list',
      'gallery',
      'caption'
    ) );

    /*
     * Enable support for Post Formats.
     *
     * See: https://codex.wordpress.org/Post_Formats
     */
    add_theme_support( 'post-formats', array(
      'aside',
      'image',
      'video',
      'quote',
      'link',
      'gallery',
      'status',
      'audio',
      'chat'
    ) );

  }
endif; // theme_setup
add_action( 'after_setup_theme', 'theme_setup' );


/**
 * Declare post types
 *
 * Learn more: {@link http://codex.wordpress.org/Function_Reference/register_post_type}
 */

/* Staff */
add_action( 'init', 'post_type_staff' );

function post_type_staff() {
  register_post_type( 'staff',
    array(
      'label'         => __( 'Staff' ),
      'public'        => TRUE,
      'menu_position' => 6,
      'menu_icon'     => 'dashicons-groups',
      'rewrite'       => array(
        'slug' => 'staff',
      ),
      'supports'      => array(
        'title',
        'thumbnail',
        'editor'
      )
    )
  );
}

/* DJ`s */
add_action( 'init', 'post_type_dj' );
function post_type_dj() {
  register_post_type( 'dj',
    array(
      'label'         => __( 'Dj' ),
      'public'        => TRUE,
      'menu_position' => 7,
      'menu_icon'     => 'dashicons-universal-access-alt',
      'rewrite'       => array(
        'slug' => 'dj',
      ),
      'supports'      => array(
        'title',
        'thumbnail',
        'editor'
      )
    )
  );
}

/* Daily programs */
add_action( 'init', 'post_type_daily_program' );

function post_type_daily_program() {
  register_post_type( 'daily_program',
    array(
      'label'         => __( 'Daily programs' ),
      'public'        => TRUE,
      'menu_position' => 8,
      'menu_icon'     => 'dashicons-microphone',
      'rewrite'       => array(
        'slug' => 'daily_program'
      ),
      'supports'      => array(
        'title',
        'editor',
        //'custom-fields'
      )
    )
  );
}

/* Programs */
add_action( 'init', 'post_type_programs' );
function post_type_programs() {
  register_post_type( 'programs',
    array(
      'label'         => __( 'Programs' ),
      'public'        => TRUE,
      'menu_icon'     => 'dashicons-format-audio',
      'menu_position' => 9,
      'rewrite'       => array(
        'slug' => 'programs',
      ),
      'supports'      => array(
        'title',
        'excerpt',
        'thumbnail',
        'editor'
      )
    )
  );
  register_taxonomy( 'programs_category', 'programs', array(
    'label'        => 'Programs Categories',
    'hierarchical' => TRUE
  ) );
}

/* Gallery */
add_action( 'init', 'post_type_gallery' );
function post_type_gallery() {
  register_post_type( 'gallery',
    array(
      'label'           => __( 'Gallery' ),
      'public'          => TRUE,
      'capability_type' => 'page',
      'menu_icon'       => 'dashicons-camera',
      'menu_position'   => 10,
      'rewrite'         => array(
        'slug'       => 'gallery-view',
        'with_front' => TRUE,
      ),
      'supports'        => array(
        'title'
      )
    )
  );
  register_taxonomy( 'gallery_category', 'gallery', array(
    'label'        => 'Gallery Categories',
    'hierarchical' => TRUE
  ) );
}

/* Events */
add_action( 'init', 'post_type_event' );

function post_type_event() {
  register_post_type( 'event',
    array(
      'label'         => __( 'Events' ),
      'public'        => TRUE,
      'menu_position' => 11,
      'menu_icon'     => 'dashicons-clipboard',
      'rewrite'       => array(
        'slug' => 'events'
      ),
      'supports'      => array(
        'title',
        'thumbnail',
        'editor'
      )
    )
  );
}