<?php
/**
 * Register widget area.
 *
 * @link https://codex.wordpress.org/Function_Reference/register_sidebar
 */

function theme_widgets_init() {

// Header blocks
// Location: header, above menu
  register_sidebar( array(
    'name'          => __( 'Header blocks' ),
    'id'            => 'header-blocks',
    'description'   => __( 'Displayed in the header on all pages' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ) );

// Main Sidebar
// Location: right sidebar on the blog page
  register_sidebar( array(
    'name'          => __( 'Sidebar' ),
    'id'            => 'sidebar',
    'description'   => __( 'Displayed in the Blog page template' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ) );

// Sidebar Secondary
// Location: right sidebar
  register_sidebar( array(
    'name'          => __( 'Sidebar Secondary' ),
    'id'            => 'sidebar-secondary',
    'description'   => __( 'Outputs content in the Sidebar Right page template' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ) );

// Sidebar Dj
// Location: sidebar
  register_sidebar( array(
    'name'          => __( 'Sidebar Dj' ),
    'id'            => 'sidebar-dj',
    'description'   => __( 'Shows on the Dj single pages' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ) );

// Sidebar Programs
// Location: sidebar
  register_sidebar( array(
    'name'          => __( 'Sidebar Programs' ),
    'id'            => 'sidebar-programs',
    'description'   => __( 'Shows on the Programs single pages' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ) );

// Sidebar home top
  register_sidebar( array(
    'name'          => __( 'Sidebar Home Top' ),
    'id'            => 'sidebar-home-top',
    'description'   => __( 'Shows on the Home page -> above the content.' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ) );

// Sidebar home left
  register_sidebar( array(
    'name'          => __( 'Sidebar Home Left' ),
    'id'            => 'sidebar-home-left',
    'description'   => __( 'Shows on the Home page -> left column.' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ) );

// Sidebar home right
  register_sidebar( array(
    'name'          => __( 'Sidebar Home Right' ),
    'id'            => 'sidebar-home-right',
    'description'   => __( 'Shows on the Home page -> right column.' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ) );

// Footer blocks
// Location: footer blocks
  register_sidebar( array(
    'name'          => __( 'Footer blocks' ),
    'id'            => 'footer-blocks',
    'description'   => __( 'Footer blocks' ),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h5 class="widget-title">',
    'after_title'   => '</h5>',
  ) );

}

add_action( 'widgets_init', 'theme_widgets_init' );
