<?php

/**
 * Layout controls & grid markup based on Bootstrap version 3.* framework.
 *
 * @version     1.0
 */

// Container
function container_shortcode( $atts, $content = NULL ) {

  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<div class="container ' . $class . '">';
  $output .= do_shortcode( $content );
  $output .= '</div> <!-- .container (end) -->';

  return $output;
}

add_shortcode( 'container', 'container_shortcode' );

// Row
function row_shortcode( $atts, $content = NULL ) {

  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<div class="row ' . $class . '">';
  $output .= do_shortcode( $content );
  $output .= '</div> <!-- .row (end) -->';

  return $output;
}

add_shortcode( 'row', 'row_shortcode' );

// Row inner
function row_inner_shortcode( $atts, $content = NULL ) {

  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<div class="row ' . $class . '">';
  $output .= do_shortcode( $content );
  $output .= '</div> <!-- .row inner (end) -->';

  return $output;
}

add_shortcode( 'row_inner', 'row_inner_shortcode' );

/**
 * Columns: add bootstrap classes to make grid layout.
 * Eg.: [column class="col-sm-6"]
 */
function column_shortcode( $atts, $content = NULL ) {

  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  $return = '<div class="' . $class . '">';
  $return .= do_shortcode( $content );
  $return .= '</div><!-- column (end) -->';

  return $return;
}

add_shortcode( 'column', 'column_shortcode' );

// Column inner
function column_inner_shortcode( $atts, $content = NULL ) {

  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  $return = '<div class="' . $class . '">';
  $return .= do_shortcode( $content );
  $return .= '</div>';

  return $return;
}

add_shortcode( 'column_inner', 'column_inner_shortcode' );

// Wrapper
function wrapper_shortcode( $atts, $content = NULL ) {

  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<div class="wrapper ' . $class . '">';
  $output .= do_shortcode( $content );
  $output .= '</div> <!-- .wrapper (end) -->';

  return $output;
}

add_shortcode( 'wrapper', 'wrapper_shortcode' );

// Universal block wrapper for styling purposes.
function block_shortcode( $atts, $content = NULL ) {

  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<div class="block ' . $class . '">';
  $output .= do_shortcode( $content );
  $output .= '</div>';

  return $output;
}

add_shortcode( 'block', 'block_shortcode' );

// Clear
function clear_shortcode( $atts, $content = NULL ) {

  $output = '<div class="clear"></div>';

  return $output;
}

add_shortcode( 'clear', 'clear_shortcode' );

// Spacer
function spacer_shortcode( $atts, $content = NULL ) {

  $output = '<div class="spacer"></div>';

  return $output;
}

add_shortcode( 'spacer', 'spacer_shortcode' );


/**
 * Content adding section
 */
// Content (list of recent posts by default)
// todo: make shortcode more flexible and universal.
function shortcode_content( $atts, $content = NULL ) {

  extract( shortcode_atts( array(
    'post_type'        => 'post',
    'category'         => '',
    'custom_category'  => '',
    'layout'           => 'primary',
    'num'              => '-1',
    'meta'             => 'false',
    'thumb'            => 'false',
    'thumb_width'      => '120',
    'thumb_height'     => '120',
    'more_text_single' => '',
    'excerpt_count'    => '0',
    'content_count'    => '0',
    'wrapper_tag'      => 'div',
    'class'            => '',
    'class_item'       => ''
  ), $atts ) );

  if ( $wrapper_tag == 'div' ) {
    $item_tag = $wrapper_tag;
  } else {
    $item_tag = 'li';
  }

  $output = '<' . $wrapper_tag . ' class="recent-posts ' . $class . '">';
  // Split items into columns.
  /*if ( $layout == 'secondary' ) {
    $output .= '<div class="column ' . $class_item . '">';
  }*/

  global $post;

  $args = array(
    'post_type'              => $post_type,
    'category_name'          => $category,
    $post_type . '_category' => $custom_category,
    'numberposts'            => $num,
    'orderby'                => 'post_date',
    'order'                  => 'DESC'
  );

  $latest = get_posts( $args );

  $i = 0;
  foreach ( $latest as $post ) {
    setup_postdata( $post );
    $excerpt        = get_the_excerpt( $post->ID );
    $content        = get_the_content( $post->ID );
    $attachment_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
    $url            = $attachment_url['0'];
    $image          = aq_resize( $url, $thumb_width, $thumb_height, TRUE );


    $post_classes = get_post_class();

    foreach ( $post_classes as $key => $value ) {
      $pos = strripos( $value, 'tag-' );
      if ( $pos !== FALSE ) {
        unset( $post_classes[ $i ] );
      }
    }
    $post_classes = implode( ' ', $post_classes );

    // Major layouts.
    switch ( $layout ) {
      // Default layout.
      case 'primary':
        $output .= '<' . $item_tag . ' class="item ' . $post_classes . ' ' . $class_item . '"><div class="wrapper">';

        if ( $thumb == 'true' ) {

          if ( has_post_thumbnail( $post->ID ) ) {
            $output .= '<figure class="featured-thumbnail"><a href="' . get_permalink( $post->ID ) . '" title="' . get_the_title( $post->ID ) . '">';
            if ( $image ) {
              $output .= '<img  src="' . $image . '" alt="' . get_the_title( $post->ID ) . '"/>';
            } else {
              $output .= '<img  src="' . $url . '" alt="' . get_the_title( $post->ID ) . '"/>';
            }
            $output .= '</a></figure>';
          }
        }


        $output .= '<div class="wrap-info">';

        $output .= '<h5><a href="' . get_permalink( $post->ID ) . '" title="' . get_the_title( $post->ID ) . '">';
        $output .= get_the_title( $post->ID );
        $output .= '</a></h5>';


        if ( $meta == 'true' ) {
          $output .= '<span class="meta">';
          $output .= '<span class="day">' . get_the_time( 'd' ) . '/</span><span class="months">' . get_the_time( 'm' ) . '/</span><span class="year">' . get_the_time( 'Y' ) . '</span>';
          $output .= '</span>';
        }

        if ( $excerpt_count >= 1 || $content_count >= 1 ) {

          $output .= '<div class="post-content">';
          if ( $excerpt_count >= 1 ) {

            $output .= '<div class="excerpt">';
            $output .= trim_string_length( $excerpt, $excerpt_count );
            $output .= '</div>';
          }
          if ( $content_count >= 1 ) {
            $output .= '<div class="content">';
            $output .= trim_string_length( $content, $content_count );
            $output .= '</div>';
          }
          $output .= '</div>';
        }


        if ( $more_text_single != "" ) {
          $output .= '<a href="' . get_permalink( $post->ID ) . '" class="readmore" title="' . get_the_title( $post->ID ) . '">';
          $output .= $more_text_single;
          $output .= '</a>';
        }

        $output .= '</div>';

        $output .= '</div></' . $item_tag . '><!-- .entry (end) -->';
        break;

      // Secondary layout.
      case 'secondary':
        $i ++;

        $output .= '<' . $item_tag . ' class="item item-' . $i . '">';

        if ( $thumb == 'true' ) {

          if ( has_post_thumbnail( $post->ID ) ) {
            $output .= '<figure class="featured-thumbnail">';
            if ( $image ) {
              $output .= '<img  src="' . $image . '" alt="' . get_the_title( $post->ID ) . '"/>';
            } else {
              $output .= '<img  src="' . $url . '" alt="' . get_the_title( $post->ID ) . '"/>';
            }
            $output .= '</figure>';
          }
        }


        $output .= '<div class="wrap-info">';

        if ( $excerpt_count >= 1 ) {

          $output .= '<div class="excerpt">';
          $output .= trim_string_length( $excerpt, $excerpt_count );
          $output .= '</div>';
        }

        if ( $content_count >= 1 ) {
          $output .= '<div class="content">';
          $output .= trim_string_length( $content, $content_count );
          $output .= '</div>';
        }

        $output .= '<h5><a href="' . get_permalink( $post->ID ) . '" title="' . get_the_title( $post->ID ) . '">';
        $output .= get_the_title( $post->ID );
        $output .= '</a></h5>';

        if ( $meta == 'true' ) {
          $output .= '<span class="meta">';
          $output .= '<span class="day">' . get_the_time( 'd' ) . '/</span><span class="months">' . get_the_time( 'm' ) . '/</span><span class="year">' . get_the_time( 'Y' ) . '</span>';
          $output .= '</span>';
        }

        $output .= '</div>';

        $output .= '</' . $item_tag . '><!-- .entry (end) -->';

        break;

      // Custom layout.
      case 'custom':
        $i ++;
        $output .= '<div class="item item-' . $i . ' ' . $post_classes . ' ' . $class_item . '">';

        // Custom fields.
        $output .= '<div class="date">';
        $output .= '<span class="day">' . rwmb_meta( 'day' ) . '</span>';
        $output .= '<span class="month">' . rwmb_meta( 'month' ) . '</span>';
        $output .= '</div>';

        $output .= '<div class="wrap-info">';
        $output .= '<h5>' . get_the_title( $post->ID ) . '</h5>';
        if ( $content_count >= 1 ) {
          $output .= '<div class="content">';
          $output .= trim_string_length( $content, $content_count );
          $output .= '</div>';
        }

        // wrap-info end.
        $output .= '</div>';

        $output .= '</div><!-- .entry (end) -->';
        break;
    }

  }
  /*if ( $layout == 'secondary' ) {
    $output .= '</div>';
  }*/
  $output .= '</' . $wrapper_tag . '><!-- .recent-posts (end) -->';

  wp_reset_postdata();

  return $output;

}

add_shortcode( 'content', 'shortcode_content' );


// Google map (custom styles).
function map_shortcode() {
  $output = "<div id='map'><i class=\"fa fa-spinner fa-pulse\"></i></div>";
  $output .= "<script type='text/javascript' src='https://maps.googleapis.com/maps/api/js'></script>";
  $output .= "<script type='text/javascript' src='" . get_template_directory_uri() . "/js/map_styles.js'></script>";

  return $output;

}

add_shortcode( 'map', 'map_shortcode' );

// Tabs.
// Tab content.
function tab_content_shortcode( $atts, $content = NULL ) {
  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<div class="tab-content ' . $class . '">';
  $output .= do_shortcode( $content );
  $output .= '</div><!-- Tab panes -->';

  return $output;

}

add_shortcode( 'tab_content', 'tab_content_shortcode' );

// Tab panel.
function tab_panel_shortcode( $atts, $content = NULL ) {
  extract( shortcode_atts( array(
    'id'    => '',
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<div class="tab-pane fade ' . $class . '" id="' . $id . '">';
  $output .= do_shortcode( $content );
  $output .= '</div>';

  return $output;

}

add_shortcode( 'tab_panel', 'tab_panel_shortcode' );

// Nav tabs.
function tabs_shortcode( $atts, $content = NULL ) {
  extract( shortcode_atts( array(
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<ul class="nav nav-tabs ' . $class . '">';
  $output .= do_shortcode( $content );
  $output .= '</ul><!-- Nav tabs -->';

  return $output;

}

add_shortcode( 'tabs', 'tabs_shortcode' );

// Nav tab.
function tab_shortcode( $atts, $content = NULL ) {
  extract( shortcode_atts( array(
    'id'    => '',
    'class' => ''
  ), $atts ) );

  // add divs to the content
  $output = '<li role="presentation">';
  $output .= '<a href="#' . $id . '" aria-controls="' . $id . '" role="tab" data-toggle="tab">';
  $output .= do_shortcode( wp_strip_all_tags( $content ) );
  $output .= '</a></li>';

  return $output;

}

add_shortcode( 'tab', 'tab_shortcode' );

// Facebook.
function facebook_shortcode( $atts, $content = NULL ) {
  extract( shortcode_atts( array(
    'url' => '',
  ), $atts ) );
  // todo: move script right after <body> via add_action.
  $output = '<div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.5&appId=227897514458";
  fjs.parentNode.insertBefore(js, fjs);
}(document, \'script\', \'facebook-jssdk\'));</script>';

  $output .= '<div class="fb-page" data-href="' . $url . '" data-width="300" data-height="280" data-small-header="true" data-adapt-container-width="true" data-hide-cover="false" data-show-facepile="true" data-show-posts="false"><div class="fb-xfbml-parse-ignore"></div></div>';


  return $output;

}

add_shortcode( 'facebook', 'facebook_shortcode' );


// Time span block.
function time_shortcode( $atts, $content = NULL ) {

  // add divs to the content
  $output = '<span class="time">';
  $output .= do_shortcode( $content );
  $output .= '</span>';

  return $output;
}

add_shortcode( 'time', 'time_shortcode' );

// Title block.
function title_shortcode( $atts, $content = NULL ) {

  // add divs to the content
  $output = '<div class="title">';
  $output .= do_shortcode( $content );
  $output .= '</div>';

  return $output;
}

add_shortcode( 'title', 'title_shortcode' );

