<article id="post-<?php the_ID(); ?>" <?php post_class( 'post-holder' ); ?>>

  <?php get_template_part( 'includes/post-formats/post-thumb' ); ?>
  <div class="wrap-info">

    <?php if ( ! is_singular() ) : ?>
      <div class="title-row">
        <h2 class="entry-title">
          <a href="<?php the_permalink(); ?>">
            <?php the_title(); ?>
          </a>
        </h2>
      </div>
    <?php endif; ?>
    <div class="entry-content">
      <?php
      // Exclude meta on default singular page.
      if ( ! is_singular() ) { ?>
        <?php get_template_part( 'includes/post-formats/post-meta' ); ?>
      <?php } ?>

      <?php if ( ! is_singular() ) { ?>

        <div class="post-content">
          <?php
          $post_excerpt = 'true';
          ?>
          <?php if ( $post_excerpt == 'true' || $post_excerpt == '' ) { ?>
            <div class="excerpt">
              <?php
              $content = get_the_content();
              $excerpt = get_the_excerpt();
              if ( has_excerpt() ) {
                echo trim_string_length( $excerpt, 75 );
              } else {
                if ( ! is_search() ) {
                  echo trim_string_length( $content, 55 );
                } else {
                  echo trim_string_length( $excerpt, 55 );
                }
              }
              ?>
            </div>
          <?php } ?>
          <a href="<?php the_permalink() ?>" title="<?php _e( 'Continue reading ' );
          the_title(); ?>"
             class="btn"><?php _e( 'Read more' ); ?></a>
        </div>

      <?php } else { ?>
        <div class="content">
          <?php the_content( '' ); ?>
        </div>
      <?php } ?>
    </div>
  </div>
</article>