<?php
/*
 * File Name: config-meta-boxes.php
 *
 * Declaring meta boxes and initialization.
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 */


/**
 * Prefix of meta keys (optional)
 * Use underscore (_) at the beginning to make keys hidden
 * Alt.: You also can make prefix empty to disable it
 */
// Better has an underscore as last sign
//$prefix = 'theme_';


/**
 * Declare meta boxes
 */

global $meta_boxes;

// Custom css page class
$meta_boxes[] = array(
  'id'         => 'functional-meta-box',
  'title'      => __( 'Functional', 'framework' ),
  'post_types' => array( 'page' ),
  'context'    => 'side',
  'priority'   => 'low',
  'fields'     => array(
    array(
      'name' => __( 'Page class', 'framework' ),
      'id'   => "page-class",
      'desc' => __( 'Add custom css class to the body tag', 'framework' ),
      'type' => 'text'
    )
  )
);

// Slogan & featured text.
// Not used ATM.
$meta_boxes[] = array(
  'id'         => 'header-background-meta-box',
  'title'      => __( 'Header section', 'framework' ),
  'post_types' => array(),
  'context'    => 'normal',
  'priority'   => 'high',
  'fields'     => array(
    array(
      'name' => __( 'Slogan', 'framework' ),
      'id'   => "header-slogan",
      'desc' => __( 'Add slogan text here', 'framework' ),
      'type' => 'text'
    ),
    array(
      'name' => __( 'Header background', 'framework' ),
      'id'   => "header-background",
      'type' => 'image_advanced'
    )
  )
);

// Custom fields for programs post type.
$meta_boxes[] = array(
  'id'         => 'programs-meta-box',
  'title'      => __( 'Info' ),
  'post_types' => array( 'programs' ),
  'context'    => 'normal',
  'priority'   => 'high',
  'fields'     => array(
    array(
      'name' => __( 'Date' ),
      'id'   => "date",
      'desc' => __( 'program date' ),
      'type' => 'text'
    ),
    /* this shows both : date & time.
     * array(
      'name' => __( 'Datetime' ),
      'id'   => "datetime",
      'desc' => __( 'set program date' ),
      'type' => 'datetime'
    ),*/

    /*array(
      'name'    => __( 'Day' ),
      'id'      => "day",
      'desc'    => __( 'select day' ),
      'type'    => 'select_advanced',
      'options' => array(
        'Sunday'    => __( 'Sunday' ),
        'Monday'    => __( 'Monday' ),
        'Tuesday'   => __( 'Tuesday' ),
        'Wednesday' => __( 'Wednesday' ),
        'Thursday'  => __( 'Thursday' ),
        'Friday'    => __( 'Friday' ),
        'Saturday'  => __( 'Saturday' ),
      )
    ),
    array(
      'name'       => __( 'Time' ),
      'id'         => "time",
      'desc'       => __( 'set program hours' ),
      'type'       => 'time',
      'js_options' => array(
        'stepMinute' => 5,
        'showSecond' => FALSE,
      ),
    )*/
  )
);

// Daily program meta box (used in apartments post type).
// not used
$meta_boxes[] = array(
  'id'         => 'daily_program-meta-box',
  'title'      => __( 'Custom' ),
  'post_types' => array( 'daily_program' ),
  'context'    => 'normal',
  'priority'   => 'low',
  // List of meta fields
  'fields'     => array(
    array(
      'name'    => __( 'Day' ),
      'id'      => "day",
      'desc'    => __( 'select day' ),
      'type'    => 'select_advanced',
      'options' => array(
        'Sunday'    => __( 'Sunday' ),
        'Monday'    => __( 'Monday' ),
        'Tuesday'   => __( 'Tuesday' ),
        'Wednesday' => __( 'Wednesday' ),
        'Thursday'  => __( 'Thursday' ),
        'Friday'    => __( 'Friday' ),
        'Saturday'  => __( 'Saturday' ),
      )
    )
    /*    array(
          'name'        => __( 'Programs' ),
          'id'          => "program",
          'placeholder' => __( 'aa' ),
          'desc'        => __( 'Textarea description'),
          'type'        => 'wysiwyg',
          'clone'       => TRUE,
        )*/
  )
);

// Events
$meta_boxes[] = array(
  'id'         => 'evets-meta-box',
  'title'      => __( 'Custom' ),
  'post_types' => array( 'event' ),
  'context'    => 'normal',
  'priority'   => 'low',
  // List of meta fields
  'fields'     => array(
    array(
      'name' => __( 'Day' ),
      'id'   => "day",
      'type' => 'text',
    ),
    array(
      'name' => __( 'Month' ),
      'id'   => "month",
      'type' => 'text',
    )
  )
);



/**
 * Register meta boxes
 *
 * @return void
 */
function theme_register_meta_boxes() {
  // Make sure there's no errors when the plugin is deactivated or during upgrade
  if ( ! class_exists( 'RW_Meta_Box' ) ) {
    return;
  }

  global $meta_boxes;
  foreach ( $meta_boxes as $meta_box ) {
    new RW_Meta_Box( $meta_box );
  }
}

// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'theme_register_meta_boxes' );
