<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <link rel="profile" href="http://gmpg.org/xfn/11">

  <!--Favicon set for various devices-->
  <link rel="apple-touch-icon" sizes="57x57"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-57x57.png">
  <link rel="apple-touch-icon" sizes="60x60"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-60x60.png">
  <link rel="apple-touch-icon" sizes="72x72"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-72x72.png">
  <link rel="apple-touch-icon" sizes="76x76"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-76x76.png">
  <link rel="apple-touch-icon" sizes="114x114"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-114x114.png">
  <link rel="apple-touch-icon" sizes="120x120"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-120x120.png">
  <link rel="apple-touch-icon" sizes="144x144"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-144x144.png">
  <link rel="apple-touch-icon" sizes="152x152"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-152x152.png">
  <link rel="apple-touch-icon" sizes="180x180"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/apple-touch-icon-180x180.png">
  <link rel="icon" type="image/png"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/favicon-32x32.png" sizes="32x32">
  <link rel="icon" type="image/png"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/android-chrome-192x192.png" sizes="192x192">
  <link rel="icon" type="image/png"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/favicon-96x96.png" sizes="96x96">
  <link rel="icon" type="image/png"
        href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/favicon-16x16.png" sizes="16x16">
  <link rel="manifest" href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/manifest.json">
  <link rel="mask-icon" href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/safari-pinned-tab.svg"
        color="#18b7e4">
  <link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/favicon.ico">
  <meta name="msapplication-TileColor" content="#da532c">
  <meta name="msapplication-TileImage"
        content="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/mstile-144x144.png">
  <meta name="msapplication-config"
        content="<?php echo get_stylesheet_directory_uri(); ?>/images/favicons/browserconfig.xml">
  <meta name="theme-color" content="#ffffff">

  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<!--<div class="site-preloader"></div>-->
<div id="cbp-so-scroller" class="site">

  <header class="site-header clearfix">

    <div class="row-top">
      <div class="container">
        <div class="custom-top">
          <?php echo show_text_block( 'custom-top', TRUE ); ?>
        </div>
        <div class="social-icons">
          <?php echo show_text_block( 'social-icons', TRUE ); ?>
        </div>
      </div>
    </div>

    <div class="row-logo">
      <div class="container">
        <div class="site-logo">
          <?php echo show_text_block( 'logo', TRUE ); ?>
        </div>
        <div class="header-blocks clearfix">
          <div class="search-form-wrapper">
            <?php get_search_form( TRUE ); ?>
            <i class="fa fa-search"></i>
          </div>
          <div class="listen-live">
            <?php echo show_text_block( 'listen-live', TRUE ); ?>
          </div>
          <?php // dynamic_sidebar( 'header-blocks' ); ?>
        </div>
      </div>
    </div>

    <div class="row-menu">

      <!--Primary menu-->
      <!-- Mobile menu button -->
      <a href="#menu_mobile" class="mobile-menu-icon">
        <i class="fa fa-bars"></i>
        <i class="fa fa-times"></i>
      </a>

      <div class="mobile-top visible-xs">
        <?php echo show_text_block( 'mobile-top', TRUE ); ?>
      </div>

      <div class="container">
        <!-- .header-menu = additional DOM element to prevent inheritance of the superfish menu styles to the mobile menu -->
        <div class="header-menu hidden-xs">
          <nav id="menu_mobile" class="nav-primary">
            <?php wp_nav_menu( array(
              'menu'       => 'Primary',
              'container'  => 'ul',
              'menu_class' => 'main-menu clearfix'
            ) );
            ?>
          </nav>
        </div>

      </div>
    </div>
  </header>

  <div id="content">
    <?php if ( ! is_front_page() ) { ?>
      <?php if ( function_exists( 'bcn_display' ) ) { ?>
        <div class="breadcrumbs">
          <div class="container">
            <div class="bcn">
              <?php bcn_display(); ?>
            </div>
          </div>
        </div>
      <?php } ?>
    <?php } ?>
    <div class="site-content">
