<?php
/**
 * Home page template
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 */

get_header(); ?>

<div class="container">
  <main class="main-column">

    <div class="row-slider">
      <div class="row">
        <div class="col-md-8 col-md-push-4">
          <?php echo do_shortcode( "[metaslider id=245]" ); ?>
        </div>
        <div class="col-md-4 col-md-pull-8">
          <div class="daily_programs">
            <div class="items">
              <?php
              $current_day = date( 'l' );
              $args        = array(
                'post_type'  => 'daily_program',
                'meta_key'   => 'day',
                'meta_value' => $current_day,
              );
              $posts_array = get_posts( $args );
              foreach ( $posts_array as $post ) : setup_postdata( $post ); ?>

                <?php //the_title(); ?>
                <?php the_content(); ?>

              <?php endforeach;
              wp_reset_postdata();
              ?>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row-featured-links">
      <div class="row">
        <?php echo show_text_block( 'featured-links' ); ?>
      </div>
    </div>

    <div class="row-sidebar-home-top">
      <div class="row">
        <?php dynamic_sidebar( 'sidebar-home-top' ); ?>
      </div>
    </div>

    <div class="row-main-content">
      <div class="row">
        <div class="col-sm-12 col-lg-7 col-lg-push-2">
          <div class="content-column">
            <?php
            // Start the loop.
            while ( have_posts() ) : the_post();
              the_content();
            endwhile;
            ?>
          </div>
        </div>
        <div class="sidebar col-sm-5 col-lg-2 col-lg-pull-7">
          <?php dynamic_sidebar( 'sidebar-home-left' ); ?>
        </div>
        <div class="sidebar-home-right col-sm-7 col-lg-3">
          <?php dynamic_sidebar( 'sidebar-home-right' ); ?>
        </div>
      </div>
    </div>


  </main>
</div>

<?php get_footer(); ?>
