<?php class newses_multi_grid_posts extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'newses-widget-multi-grid-posts',
			'description' => __('Display Multi Grid Posts', 'newses')
		);
		parent::__construct(false, $name = __('AR: Multi Grid Posts Widget', 'newses') , $widget_ops);
	}

	function form($instance) {

		$instance = wp_parse_args(
			(array) $instance,
			array(
				'widget_title' => '',
				'category' => '',
				'type' => 1,
				'style' => 0,
			)
		);
		$title = isset( $instance['widget_title'] ) ? $instance['widget_title'] : '';
		$type = ( isset($instance['type']) && is_numeric($instance['type']) ) ? (int) $instance['type'] : 1; ?>
		<p>
			<?php esc_html_e('Set featured image on the related post if you need to display image.', 'newses'); ?>
		</p>
		<p>
			<input id="<?php echo $this->get_field_id('style'); ?>" name="<?php echo $this->get_field_name('style'); ?>" type="checkbox" value="1" <?php checked( '1', absint($instance['style']) ); ?>/>
			<label for="<?php echo $this->get_field_id('style'); ?>">
				<?php esc_html_e('Horizontal Style','newses'); ?>
			</label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('widget_title'); ?>">
				<?php esc_html_e('Title: ', 'newses'); ?>
			</label>
			<input id="<?php echo $this->get_field_id('widget_title'); ?>" name="<?php echo $this->get_field_name('widget_title'); ?>" type="text" value="<?php echo esc_attr($title); ?>"/>
		</p>
		<p>
			<input type="radio" id="<?php echo ($this->get_field_id('type') . '-1'); ?>" name="<?php echo ($this->get_field_name('type')); ?>" value="1" <?php checked($type == 1, true); ?>>
			<label for="<?php echo ($this->get_field_id('type') . '-1'); ?>" class="input-label"><?php esc_html_e('Latest Posts', 'newses'); ?></label>
			<br>
			<input type="radio" id="<?php echo ($this->get_field_id( 'type') . '-2'); ?>" name="<?php echo ($this->get_field_name('type')); ?>" value="2" <?php checked($type == 2, true); ?>>
			<label for="<?php echo ($this->get_field_id('type') . '-2'); ?>" class="input-label"><?php esc_html_e('Show Posts from Category', 'newses'); ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('category'); ?>">
				<?php esc_html_e('Choose Category:', 'newses'); ?>
			</label>
			<?php wp_dropdown_categories(
				array(
					'show_option_none' => ' ',
					'name' => $this->get_field_name('category') ,
					'selected' => $instance['category']
				)
			); ?>
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['category'] = absint($new_instance['category']);
		$instance['style'] = absint($new_instance['style']);
		$instance['widget_title'] = sanitize_text_field($new_instance['widget_title']);
		$instance['type'] = ( isset($new_instance['type']) && $new_instance['type'] > 0 && $new_instance['type'] < 3 ) ? (int) $new_instance['type'] : 1;
		return $instance;
	}

	function widget($args, $instance) {

		$category = isset($instance['category']) ? $instance['category'] : '';
		$style = empty($instance['style']) ? '' : $instance['style'];
		$widget_title = apply_filters( 'widget_title', empty( $instance['widget_title'] ) ? '' : $instance['widget_title'], $instance, $this->id_base );
		$type = ( isset($instance['type']) && is_numeric($instance['type']) ) ? (int) $instance['type'] : 1;
		global $post;

		$post_type = array(
			'posts_per_page' => 5,
			'post_type' => array('post'),
			'post__not_in' => get_option('sticky_posts'),
		);
		if ( $type == 2 ) {
			$post_type['category__in'] = $category;
		}

		$get_featured_posts = new WP_Query($post_type);

		//echo $args['before_widget']; ?>
            <!-- mg-sec-title -->
            <div class="d-flex flex-wrap mr-bot30">
       		<?php newses_site_title_design($widget_title); ?>
				<div class="col-md-6 no-padding pr1px mb1px">
					<?php
					$i=1;
					while ($get_featured_posts->have_posts()):$get_featured_posts->the_post(); ?>
					<?php if ( $i == 1 ) { ?>
						<div class="mg-blog-post-3 lg back-img" 
							<?php if ( has_post_thumbnail() ) { 
							$url = newses_get_freatured_image_url($post->ID, 'newses-featured'); ?>
		                            	style="background-image: url('<?php echo esc_url($url); ?>');"
								<?php } ?>>
								<a href="<?php the_permalink(); ?>" class="link-div"></a>
								<div class="mg-blog-inner">
	                    	<div class="mg-blog-category"> <?php newses_post_categories(); ?> </div>
	                    	<h4 class="title lg"> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
	                	</div>
					</div><!-- post-boxed -->
				</div>
					<?php } if($i == 2) { ?>
						<div class="col-md-3 no-padding pr1px">
							<div class="mg-blog-post-3 md back-img mb1px" 
							<?php if ( has_post_thumbnail() ) { 
							$url = newses_get_freatured_image_url($post->ID, 'newses-featured'); ?>
		                            	style="background-image: url('<?php echo esc_url($url); ?>');"
								<?php } ?>>
								<a href="<?php the_permalink(); ?>" class="link-div"></a>
								<div class="mg-blog-inner">
	                    	<div class="mg-blog-category"> <?php newses_post_categories(); ?> </div>
	                    	<h4 class="title"> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
	                	</div>
							</div>
						<?php } if($i == 3) { ?>
						<div class="mg-blog-post-3 md back-img mb1px" 
							<?php if ( has_post_thumbnail() ) { 
							$url = newses_get_freatured_image_url($post->ID, 'newses-featured'); ?>
		                            	style="background-image: url('<?php echo esc_url($url); ?>');"
								<?php } ?>>
								<a href="<?php the_permalink(); ?>" class="link-div"></a>
								<div class="mg-blog-inner">
	                    	<div class="mg-blog-category"> <?php newses_post_categories(); ?> </div>
	                    	<h4 class="title"> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
	                	</div>
							</div>
						</div><!-- /col-md-6 -->
						<div class="col-md-3 no-padding">
					<?php } if($i==4 || $i==5) { ?>
					
							<div class="mg-blog-post-3 md back-img mb1px" 
							<?php if ( has_post_thumbnail() ) { 
							$url = newses_get_freatured_image_url($post->ID, 'newses-featured'); ?>
		                            	style="background-image: url('<?php echo esc_url($url); ?>');"
								<?php } ?>>
								<a href="<?php the_permalink(); ?>" class="link-div"></a>
								<div class="mg-blog-inner">
	                    		  <div class="mg-blog-category"> <?php newses_post_categories(); ?> </div>
	                    		  <h4 class="title"> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
	                			</div>
							</div>
					<?php } $i++;
					endwhile;
					// Reset Post Data
					wp_reset_postdata(); ?>
				</div>
					<div class="clearfix mr-bot30"></div>
		<?php echo $args['after_widget'] . '<!-- .widget_featured_post -->';
	}
}