<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Newses
 */

if (!function_exists('newses_post_categories')) :
    function newses_post_categories($separator = '&nbsp')
    {
        if ( 'post' === get_post_type() ) {
            $categories = wp_get_post_categories(get_the_ID());
            if(!empty($categories)){
                ?>
                
                    <?php
                    foreach($categories as $c){
                        $style = '';
                        $cat = get_category( $c );
                        $color = get_term_meta($cat->term_id, 'category_color', true);
                        if($color){
                            $style = "background-color:".esc_attr($color);
                        }
                        ?>
                        <a href="<?php echo esc_url( get_category_link( $cat->term_id ) ); ?>" style="<?php echo esc_attr($style);?>">
                            <?php echo esc_html($cat->cat_name);?>
                        </a>
                        <?php
                    }
                    ?>
                <?php
            }
        }
        
    }
endif;


if (!function_exists('newses_get_category_color_class')) :

    function newses_get_category_color_class($term_id)
    {

        $color_id = "category_color" . $term_id;
        // retrieve the existing value(s) for this meta field. This returns an array
        $term_meta = get_option($color_id);
        $color_class = ($term_meta) ? $term_meta['color_class_term_meta'] : '';
        return $color_class;


    }
endif;

/*Save Category fields*/
if(!function_exists('newses_save_category_fields')):
    function newses_save_category_fields($term_id) {
        if ( isset( $_POST['category_color'] ) && ! empty( $_POST['category_color']) ) {
            update_term_meta( $term_id, 'category_color', sanitize_hex_color( $_POST['category_color'] ) );
        }else{
            delete_term_meta( $term_id, 'category_color' );
        }
    }
endif;
add_action( 'created_category', 'newses_save_category_fields' , 10, 3 );
add_action( 'edited_category', 'newses_save_category_fields' , 10, 3 );

if (!function_exists('newses_post_meta')) :

    function newses_post_meta()
    {
    $global_post_date = get_theme_mod('global_post_date_author_setting','show-date-author');
    if($global_post_date =='show-date-author') {
    ?>
    <div class="mg-blog-meta">
        <span class="mg-blog-date"><i class="fa fa-clock-o"></i>
         <a href="<?php echo esc_url(get_month_link(get_post_time('Y'),get_post_time('m'))); ?>">
         <?php echo esc_html(get_the_date('M j, Y')); ?></a></span>
         <a class="auth" href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) ));?>"><i class="fa fa-user-o"></i> 
        <?php the_author(); ?></a> 
    </div>
    <?php } 
            elseif($global_post_date =='show-date-only') {
    ?>
    <div class="mg-blog-meta">
        <span class="mg-blog-date"><i class="fa fa-clock-o"></i>
         <a href="<?php echo esc_url(get_month_link(get_post_time('Y'),get_post_time('m'))); ?>">
         <?php echo esc_html(get_the_date('M j, Y')); ?></a></span>
    </div>
    <?php } 
            elseif($global_post_date =='show-author-only') {
    ?>
    <div class="mg-blog-meta">
        <a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) ));?>"><i class="fa fa-user-o"></i> 
        <?php the_author(); ?></a> 
    </div>
    <?php } elseif($global_post_date =='hide-date-author') { }

}
endif;

function newses_read_more() {
    
    global $post;
    
    $readbtnurl = '<br><a class="btn btn-theme post-btn" href="' . get_permalink() . '">'.__('Read More','newses').'</a>';
    
    return $readbtnurl;
}
add_filter( 'the_content_more_link', 'newses_read_more' );